﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class PromoCodesDB
    {
        public static PromoCodes GetItem(Guid productCodeID, string promoCode, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromoCodeID", ((productCodeID != Guid.Empty && productCodeID != null) ? productCodeID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@PromoCode", (string.IsNullOrEmpty(promoCode) ? (object)DBNull.Value : promoCode)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveObject<PromoCodes>("spGetPromoCode", parameters);
        }

        public static List<PromoCodes> GetList(Guid productCodeID, string promoCode, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromoCodeID", ((productCodeID != Guid.Empty && productCodeID != null) ? productCodeID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@PromoCode", (string.IsNullOrEmpty(promoCode) ? (object)DBNull.Value : promoCode)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveList<PromoCodes>("spGetPromoCode", parameters);
        }

        public static DataTable GetDataTable(Guid productCodeID, string promoCode, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromoCodeID", ((productCodeID != Guid.Empty && productCodeID != null) ? productCodeID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@PromoCode", (string.IsNullOrEmpty(promoCode) ? (object)DBNull.Value : promoCode)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataTable("spGetPromoCode", parameters);
        }

        public static DataSet GetDataSet(Guid productCodeID, string promoCode, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromoCodeID", ((productCodeID != Guid.Empty && productCodeID != null) ? productCodeID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@PromoCode", (string.IsNullOrEmpty(promoCode) ? (object)DBNull.Value : promoCode)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataSet("spGetPromoCode", parameters);
        }

        public static void Save(PromoCodes myPromoCode)
        {
            myPromoCode.Mode = ((myPromoCode.UniqueID != Guid.Empty && myPromoCode.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myPromoCode.UniqueID = ((myPromoCode.UniqueID != Guid.Empty && myPromoCode.UniqueID != null) ? myPromoCode.UniqueID : Guid.NewGuid());
            if (myPromoCode.Mode == GlobalConfigurations.Mode.Insert)
            {
                myPromoCode.IsActive = true;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromoCodeID", myPromoCode.UniqueID));
            parameters.Add(new SqlParameter("@PromoType", (string.IsNullOrEmpty(myPromoCode.PromoType) ? (object)DBNull.Value : myPromoCode.PromoType)));
            parameters.Add(new SqlParameter("@PromoCode", (string.IsNullOrEmpty(myPromoCode.PromoCode) ? (object)DBNull.Value : myPromoCode.PromoCode)));
            parameters.Add(new SqlParameter("@DiscountType", (string.IsNullOrEmpty(myPromoCode.DiscountType) ? (object)DBNull.Value : myPromoCode.DiscountType)));
            parameters.Add(new SqlParameter("@Discount", (myPromoCode.Discount == 0 ? (object)DBNull.Value : myPromoCode.Discount)));
            parameters.Add(new SqlParameter("@StartDate", (myPromoCode.StartDate == DateTime.MinValue) ? (object)DBNull.Value : myPromoCode.StartDate));
            parameters.Add(new SqlParameter("@EndDate", (myPromoCode.EndDate == DateTime.MinValue) ? (object)DBNull.Value : myPromoCode.EndDate));
            parameters.Add(new SqlParameter("@PriceRangeFrom", (myPromoCode.PriceRangeFrom == 0 ? (object)DBNull.Value : myPromoCode.PriceRangeFrom)));
            parameters.Add(new SqlParameter("@PriceRangeTo", (myPromoCode.PriceRangeTo == 0 ? (object)DBNull.Value : myPromoCode.PriceRangeTo)));
            parameters.Add(new SqlParameter("@UseFromPrice", myPromoCode.UseFromPrice));
            parameters.Add(new SqlParameter("@MaxUsage", (myPromoCode.MaxUsage == 0) ? (object)DBNull.Value : myPromoCode.MaxUsage));
            parameters.Add(new SqlParameter("@AvailableUsage", (myPromoCode.AvailableUsage == 0) ? (object)DBNull.Value : myPromoCode.AvailableUsage));
            parameters.Add(new SqlParameter("@CreatedBy", ((myPromoCode.UserAccountID != Guid.Empty && myPromoCode.UserAccountID != null) ? myPromoCode.UserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myPromoCode.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myProductCategory.IsDeleted));
            parameters.Add(new SqlParameter("@Mode", myPromoCode.Mode));

            SQLHelper.ExecuteQuery("spAddOrUpdatePromoCode", parameters);
        }
    }
}
